<?php
/**
 * License System - Database Installation
 * Run this file once to create database tables
 */

require_once 'config.php';

try {
    // Create licenses table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS licenses (
            id INT AUTO_INCREMENT PRIMARY KEY,
            license_key VARCHAR(19) UNIQUE NOT NULL,
            customer_name VARCHAR(255),
            customer_email VARCHAR(255),
            customer_telegram VARCHAR(255),
            status ENUM('active', 'inactive', 'suspended', 'expired') DEFAULT 'active',
            domain VARCHAR(255) DEFAULT NULL,
            product VARCHAR(100) DEFAULT 'elementor-page-builder-assistant',
            max_activations INT DEFAULT 1,
            current_activations INT DEFAULT 0,
            expires_at DATETIME DEFAULT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            notes TEXT,
            INDEX idx_license_key (license_key),
            INDEX idx_status (status),
            INDEX idx_domain (domain)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Create license_logs table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS license_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            license_id INT NOT NULL,
            action VARCHAR(50) NOT NULL,
            ip_address VARCHAR(45),
            details TEXT,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (license_id) REFERENCES licenses(id) ON DELETE CASCADE,
            INDEX idx_license_id (license_id),
            INDEX idx_action (action),
            INDEX idx_created_at (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    // Create admin_sessions table
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS admin_sessions (
            id INT AUTO_INCREMENT PRIMARY KEY,
            session_token VARCHAR(64) UNIQUE NOT NULL,
            ip_address VARCHAR(45),
            user_agent TEXT,
            expires_at DATETIME NOT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_token (session_token),
            INDEX idx_expires (expires_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");

    echo "✅ Database tables created successfully!\n\n";
    echo "Tables created:\n";
    echo "- licenses: Store license keys and customer info\n";
    echo "- license_logs: Track all license activities\n";
    echo "- admin_sessions: Manage admin login sessions\n\n";
    echo "Next steps:\n";
    echo "1. Edit config.php and change security keys\n";
    echo "2. Access admin panel: http://license.strikesnake.com/admin/\n";
    echo "3. Default login: admin / admin123 (CHANGE THIS!)\n";

} catch (PDOException $e) {
    die("❌ Installation failed: " . $e->getMessage());
}
