<?php
/**
 * License System Configuration
 * Domain: license.strikesnake.com
 */

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'license_system');
define('DB_USER', 'root');
define('DB_PASS', '');

// Security
define('LICENSE_SALT', 'ebi_secure_salt_2025_strikesnake'); // Değiştir!
define('API_SECRET_KEY', 'your_secret_api_key_here_change_this'); // Değiştir!

// Admin Credentials (İlk kurulumda değiştir!)
define('ADMIN_USERNAME', 'admin');
define('ADMIN_PASSWORD', password_hash('admin123', PASSWORD_BCRYPT)); // admin123 - İlk girişte değiştir!

// Database Connection
try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die(json_encode([
        'success' => false,
        'message' => 'Database connection failed: ' . $e->getMessage()
    ]));
}

// Helper Functions
function generateLicenseKey() {
    $key = '';
    for ($i = 0; $i < 4; $i++) {
        if ($i > 0) $key .= '-';
        $key .= strtoupper(bin2hex(random_bytes(2)));
    }
    return $key;
}

function hashLicense($license_key, $domain) {
    return hash('sha256', $license_key . $domain . LICENSE_SALT);
}

function logActivity($pdo, $license_id, $action, $ip, $details = null) {
    try {
        $stmt = $pdo->prepare("
            INSERT INTO license_logs (license_id, action, ip_address, details, created_at) 
            VALUES (?, ?, ?, ?, NOW())
        ");
        $stmt->execute([$license_id, $action, $ip, $details]);
    } catch (Exception $e) {
        error_log("Log error: " . $e->getMessage());
    }
}
